/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.world.cap.events;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IWorldEventHandler;
import dev.toma.gunsrpg.common.entity.AirdropEntity;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.world.cap.events.WorldEventSpec;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class AirdropEventHandler
implements IWorldEventHandler {
    final boolean isValidDimension;
    final Random random;

    public AirdropEventHandler(World world) {
        this.isValidDimension = world != null && world.func_230315_m_() == DimensionType.field_236004_h_;
        this.random = new Random();
    }

    @Override
    public void eventStarted(World world) {
        if (!this.isValidDimension) {
            return;
        }
        List playerList = world.func_217369_A();
        this.addAirdrop(world, playerList);
    }

    @Override
    public void eventFinished(World world) {
    }

    @Override
    public boolean canTriggerEvent(World world) {
        return true;
    }

    private void addAirdrop(World world, List<? extends PlayerEntity> playerList) {
        int z;
        int y;
        PlayerEntity player = ModUtils.getRandomListElement(playerList, this.random);
        GunsRPG.log.debug(WorldEventSpec.MARKER, "Preparing airdrop spawn event");
        if (player == null) {
            return;
        }
        int maxDist = 35;
        int x = (int)(player.func_226277_ct_() + (double)this.randomInRange(maxDist));
        BlockPos pos = new BlockPos(x, y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = (int)(player.func_226281_cx_() + (double)this.randomInRange(maxDist))) + 100, z);
        if (!world.func_175623_d(pos)) {
            GunsRPG.log.error("Airdrop spawning failed due to position being obstructed at {}", (Object)pos);
            return;
        }
        AirdropEntity entity = new AirdropEntity(world);
        entity.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        world.func_184148_a(null, (double)pos.func_177958_n(), player.func_226278_cu_(), (double)pos.func_177952_p(), ModSounds.PLANE_FLY_BY, SoundCategory.MASTER, 15.0f, 1.0f);
        world.func_217376_c((Entity)entity);
        if ((double)this.random.nextFloat() < GunsRPG.config.world.anotherAirdropSpawnChance) {
            this.addAirdrop(world, playerList);
        }
        GunsRPG.log.debug(WorldEventSpec.MARKER, "Created new airdrop at {} for player {}", (Object)pos, (Object)player.func_145748_c_().getString());
    }

    private int randomInRange(int range) {
        return this.random.nextInt(range) - this.random.nextInt(range);
    }
}

